<?php

function academiathemes_option_defaults() {
    $defaults = array(

        /**
         * Color Scheme
         */
        // General
        'color-body-text'                     => '#080808',
        'color-link'                          => '#1466b8',
        'color-link-hover'                    => '#910808',
        'color-frame'                         => '',
        'color-accent'                        => '#e3e3e3',
        'color-accent-anchor'                 => '#282828',
        'color-accent-hover'                  => '#910808',
        'color-accent-hover-anchor'           => '#ffffff',

        // Main Menu
        'color-menu-background'               => '#910808',
        'color-menu-link'                     => '#ffffff',
        'color-menu-link-hover'               => '#f0b042',
        'color-submenu-background'            => '#ffffff',
        'color-submenu-background-hover'      => '#f8f8f8',
        'color-submenu-menu-link'             => '#121212',
        'color-submenu-menu-link-hover'       => '#1466b8',
        'color-submenu-border-bottom'         => '#F0F0F0',

        // Mobile Menu
        'color-mobile-menu-toggle-background'         => '#080808',
        'color-mobile-menu-toggle-background-hover'   => '#910808',
        'color-mobile-menu-toggle'                    => '#ffffff',
        'color-mobile-menu-toggle-hover'              => '#ffffff',
        'color-mobile-menu-container-background'      => '#111111',
        'color-mobile-menu-link-border'               => '#333333',
        'color-mobile-menu-link'                      => '#ffffff',
        'color-mobile-menu-link-hover'                => '#f0b042',

        // Secondary Menu
        'color-secondary-menu-background'     => '#eeeeee',
        'color-secondary-menu-border'         => '#dfdfdf',
        'color-secondary-menu-link'           => '',
        'color-secondary-menu-link-hover'     => '',

        // Footer
        'color-footer-background'             => '#f2f2f2',
        'color-footer-border'                 => '#e6e6e6',
        'color-footer-text'                   => '#282828',
        'color-footer-widget-title'           => '#111111',
        'color-footer-link'                   => '#282828',
        'color-footer-link-hover'             => '#910808',

        // Footer: Credits
        'color-footer-credits-background'     => '',
        'color-footer-credits-border'         => '#e6e6e6',
        'color-footer-credits-text'           => '#777777',
        'color-footer-credits-link'           => '',
        'color-footer-credits-link-hover'     => '#910808',

        // Single Post
        'color-single-title'                  => '#111111',
        'color-single-meta'                   => '#777777',

        // Copyright
        'theme-header-style'                  => 'left',
        'theme-sidebar-position'              => 'both',
        'theme-slideshow-palette'             => 'dark',
        'theme-display-post-featured-image'   => 1,
        'footer-widgets-display'              => 1,

        /* translators: This is the copyright notice that appears in the footer of the website. */
        'theme-homepage-posts-heading'        => __('Recent Posts','fleming'),
        'fleming_copyright_text'                => sprintf( esc_html__( 'Copyright &copy; %1$s %2$s. ', 'fleming' ), date( 'Y' ), get_bloginfo( 'name' ) ),
    );

    return $defaults;
}

function academiathemes_get_default( $option ) {
    $defaults = academiathemes_option_defaults();
    $default  = ( isset( $defaults[ $option ] ) ) ? $defaults[ $option ] : false;

    return $default;
}