<?php

function academiathemes_customizer_define_general_sections( $sections ) {
    $panel           = 'academiathemes' . '_general';
    $general_sections = array();

    $theme_header_style = array(
        'left'      => esc_html__('Left', 'fleming'),
        'centered'  => esc_html__('Centered', 'fleming')
    );

    $theme_sidebar_positions = array(
        'both'      => esc_html__('Both Sidebars', 'fleming'),
        'left'      => esc_html__('Only Primary (left) Sidebar', 'fleming'),
        'right'     => esc_html__('Only Secondary (right) Sidebar', 'fleming'),
        'none'      => esc_html__('No sidebars', 'fleming')
    );

    $theme_slideshow_palettes = array(
        'dark'      => esc_html__('Dark', 'fleming'),
        'light'     => esc_html__('Light', 'fleming')
    );

    $general_sections['general'] = array(
        'panel'     => $panel,
        'title'     => esc_html__( 'General Settings', 'fleming' ),
        'priority'  => 4900,
        'options'   => array(

            'theme-header-style'     => array(
                'setting' => array(
                    'default' => 'left',
                    'sanitize_callback' => 'academiathemes_sanitize_text'
                ),
                'control' => array(
                    'label' => esc_html__( 'Header Layout', 'fleming' ),
                    'type'  => 'radio',
                    'choices' => $theme_header_style
                ),
            ),

            'theme-sidebar-position'    => array(
                'setting'               => array(
                    'default'           => 'left',
                    'sanitize_callback' => 'academiathemes_sanitize_text'
                ),
                'control'           => array(
                    'label'         => esc_html__( 'Display Sidebar(s)', 'fleming' ),
                    'type'          => 'radio',
                    'choices'       => $theme_sidebar_positions
                ),
            ),

            'theme-display-post-featured-image'    => array(
                'setting'               => array(
                    'sanitize_callback' => 'absint',
                    'default'           => 1
                ),
                'control'               => array(
                    'label'             => __( 'Display Featured Images in Posts and Pages', 'fleming' ),
                    'type'              => 'checkbox'
                )
            ),

        ),
    );

    $general_sections['homepage'] = array(
        'panel'     => $panel,
        'title'   => esc_html__( 'Homepage', 'fleming' ),
        'priority' => 4910,
        'options' => array(

            'theme-homepage-posts-heading' => array(
                'setting' => array(
                    'default'           => __('Recent Posts','fleming'),
                    'sanitize_callback' => 'sanitize_text_field',
                ),
                'control' => array(
                    'label'             => esc_html__( 'Blog Section Heading', 'fleming' ),
                    'type'              => 'text',
                ),
            ),

            'fleming-display-pages'    => array(
                'setting'               => array(
                    'sanitize_callback' => 'absint',
                    'default'           => '1'
                ),
                'control'               => array(
                    'label'             => __( 'Display Pages Slideshow on Homepage', 'fleming' ),
                    'type'              => 'checkbox'
                )
            ),

            'theme-slideshow-palette' => array(
                'setting' => array(
                    'sanitize_callback' => 'sanitize_text_field',
                    'default' => 'dark'
                ),
                'control' => array(
                    'label' => __( 'Slideshow Color Palette', 'fleming' ),
                    'type'  => 'radio',
                    'choices' => $theme_slideshow_palettes
                )
            ),

            'theme-slideshow-speed' => array(
                'setting' => array(
                    'sanitize_callback' => 'sanitize_text_field',
                    'default' => 0,
                ),
                'control' => array(
                    'label'             => esc_html__( 'Slideshow Autoplay Speed', 'fleming' ),
                    'description'       => esc_html__( 'In milliseconds. (1 second = 1000 milliseconds). 0 disables autoplay.', 'fleming' ),
                    'type'              => 'text',
                ),
            ),

            'fleming-featured-page-1'  => array(
                'setting'               => array(
                    'default'           => 'none',
                    'sanitize_callback' => 'fleming_sanitize_pages'
                ),
                'control'               => array(
                    'label'             => esc_html__( 'Slideshow Page #1', 'fleming' ),
                    'description'       => sprintf( wp_kses( __( 'This list is populated with <a href="%1$s">Pages</a>.', 'fleming' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( admin_url( 'edit.php?post_type=page' ) ) ),
                    'type'              => 'select',
                    'choices'           => fleming_get_pages()
                ),
            ),

            'fleming-featured-page-2'  => array(
                'setting'               => array(
                    'default'           => 'none',
                    'sanitize_callback' => 'fleming_sanitize_pages'
                ),
                'control'               => array(
                    'label'             => esc_html__( 'Slideshow Page #2', 'fleming' ),
                    'type'              => 'select',
                    'choices'           => fleming_get_pages()
                ),
            ),

            'fleming-featured-page-3'  => array(
                'setting'               => array(
                    'default'           => 'none',
                    'sanitize_callback' => 'fleming_sanitize_pages'
                ),
                'control'               => array(
                    'label'             => esc_html__( 'Slideshow Page #3', 'fleming' ),
                    'type'              => 'select',
                    'choices'           => fleming_get_pages()
                ),
            ),

            'fleming-featured-page-4'  => array(
                'setting'               => array(
                    'default'           => 'none',
                    'sanitize_callback' => 'fleming_sanitize_pages'
                ),
                'control'               => array(
                    'label'             => esc_html__( 'Slideshow Page #4', 'fleming' ),
                    'type'              => 'select',
                    'choices'           => fleming_get_pages()
                ),
            ),

            'fleming-featured-page-5'  => array(
                'setting'               => array(
                    'default'           => 'none',
                    'sanitize_callback' => 'fleming_sanitize_pages'
                ),
                'control'               => array(
                    'label'             => esc_html__( 'Slideshow Page #5', 'fleming' ),
                    'type'              => 'select',
                    'choices'           => fleming_get_pages()
                ),
            ),

        ),
    );

    $general_sections['footer'] = array(
        'panel'     => $panel,
        'title'   => esc_html__( 'Footer', 'fleming' ),
        'priority' => 4910,
        'options' => array(

            'fleming_copyright_text' => array(
                'setting' => array(
                    'default'           => __('Copyright &copy; ','fleming') . date("Y",time()) . ' ' . get_bloginfo('name'),
                    'sanitize_callback' => 'sanitize_text_field',
                ),
                'control' => array(
                    'label'             => esc_html__( 'Copyright Text', 'fleming' ),
                    'type'              => 'text',
                ),
            ),

            'theme-display-footer-credit' => array(
                'setting'               => array(
                    'sanitize_callback' => 'absint',
                    'default'           => 1
                ),
                'control'               => array(
                    'label'             => __( 'Display "Theme by AcademiaThemes"', 'fleming' ),
                    'type'              => 'checkbox'
                )
            ),

        ),
    );

    return array_merge( $sections, $general_sections );
}

add_filter( 'academiathemes_customizer_sections', 'academiathemes_customizer_define_general_sections' );